;----------------------------------------------------------------------------
; Sega Dreamcast
; Demul v0.5.6
; by chillinwater & djvj
; 1.0
;
; Notes:
; This script supports the following DC images: GDI, CDI, CHD, MDS, CCD, NRG, CUE
; Place your dc.zip bios in the roms subdir of your emu
; Run demul manually and goto Config->Plugins->GD-ROM Plugin and set it to gdrImage
; Set your Video Plugin to gpuOglv3
; On first run of a game, demul will ask you to setup all your plugin choices if you haven't already.
;
; If you want to convert your roms from gdi to chd, see here: http://www.emutalk.net/showthread.php?t=51502
; FileDelete(s) are in the script because sometimes demul will corrupt the ini and make it crash. The script recreates a clean ini for you.
;
; Setup the user settings below to your liking
;
; For additional setup steps prior to running, see this link: http://www.hyperspin-fe.com/forum/showpost.php?p=99852&postcount=138
;----------------------------------------------------------------------------

 ; ***USER SETTINGS***
useLoadingBlinds = black ; options are none, black, or romname
useGlobalShaderEffects = false ; options are true or false
mode = 0 ; [strength of effects] minimum=0, more=1, medium=2, maximum=3
path = C:\HyperSpin\Emulators\Sega Dreamcast\demul32-0.5.6\shaders ; you need to use full file path to the shader effects for each game
name = scanlines ; name of shader effect (No file extension)


 ; ***MAIN SCRIPT, DO NOT TOUCH IF YOU DON'T KNOW WHAT YOU ARE DOING***

SetBatchLines -1
 
If ( useLoadingBlinds = "black" ){
	;\\\optional plain black screen if you don't want to use the below Gui\\\
	Gui +AlwaysOnTop -Caption +ToolWindow 
	Gui, color, 0
	Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%, HSHIDE 
}
Else If ( useLoadingBlinds = "romname" ){
	;\\\Please Wait Loading Screen change size,color,font,& background color to whatever you want it to say\\\
	IniRead, Long_RomName, %emuPath%settings.ini, %romName%, Long_RomName
	GuiHeight:=A_ScreenHeight/9*4
	Gui, +toolwindow -Caption +AlwaysOnTop
	Gui, Color, black
	Gui, Font, S24 Cred, verdanna
	Gui, Add, Text, y%GuiHeight% W%A_ScreenWidth% H%A_ScreenHeight% Center, Please Wait! Now Loading...`n %systemname%`n`n"%romName%"
	Gui, Show, W%A_ScreenWidth% H%A_ScreenHeight%
}

;\\\add sounds\\\
 ; Sounds go in the demul directory. Change to .mp3 if desired or specify a directory of sounds for "romName"
;SoundPlay, %A_ScriptDir%\%systemName%.wav
;SoundPlay, %A_ScriptDir%\%romName%.wav
;SoundPlay, %A_ScriptDir%\%anyName%.wav
 
If ( romExtension = ".cdi" || romExtension = ".mds" || romExtension = ".ccd" || romExtension = ".nrg" || romExtension = ".gdi" || romExtension = ".cue" )
{
	FileDelete, %emuPath%gdrImage.ini
	Sleep, 500
	IniWrite, gdrImage.dll, %emuPath%Demul.ini, plugins, gdr
	IniWrite, false, %emuPath%gdrImage.ini, Main, openDialog
	IniWrite, %romPath%%romName%%romExtension%, %emuPath%gdrImage.ini, Main, imagefilename
}
Else If ( romExtension = ".chd" )
{
	FileDelete, %emuPath%gdrCHD.ini
	Sleep, 500
	IniWrite, false, %emuPath%gdrCHD.ini, Main, openDialog
	IniWrite, gdrCHD.dll, %emuPath%Demul.ini, plugins, gdr
	IniWrite, %romPath%%romName%%romExtension%, %emuPath%gdrCHD.ini, Main, imagefilename
}

 ; Shader Effects
IniRead, currentShaderValue, %emuPath%gpuOglv3.ini, shader, effects
If ( useGlobalShaderEffects = "true" ){
	If ( currentShaderValue = "false" ){
		IniWrite, true, %emuPath%gpuOglv3.ini, shader, effects
	}
	IniWrite, %mode%, %emuPath%gpuOglv3.ini, shader, mode
	IniWrite, %path%, %emuPath%gpuOglv3.ini, shader, path
	IniWrite, %name%, %emuPath%gpuOglv3.ini, shader, name
}
Else If ( useGlobalShaderEffects = "false" and currentShaderValue = "true" ){
	IniWrite, false, %emuPath%gpuOglv3.ini, shader, effects
}

Sleep, 250
Run, %executable% -run=dc, %emuPath%
Sleep, 4000 ; adjust to your liking for how long you want to see the black screen
Send !{ENTER} ; fullscreen
Gui Destroy
Process, WaitClose, %executable%
WinActivate, HyperSpin

ExitApp

CloseProcess:
	Process, Close, %executable% ; we have to close this way otherwise demul crashes with WinClose
return